/* Contain the entire script within a function because REPORTER only has a single JavaScript realm
 * for the entire session. */
chest_score();

/**
 * Performs the chest score calculation for the specified models
 */
function chest_score() {
    let template = Template.GetCurrent();
    // let models = get_model_list();
    let models = ["M1", "T1"];
    let body_region_label = "chest";

    let occupants = ["DRIVER"];

    for (let m of models) {
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} ${body_region_label} score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };
            let chest_compression_score1;
            let chest_compression_score2;
            let chest_compression_score3;
            let chest_compression_score1_banded;
            let chest_compression_score2_banded;
            let chest_compression_score3_banded;
            let chest_compression_value1;
            let chest_compression_value2;
            let chest_compression_value3;
            let chest_compression_value;

            chest_compression_score1 = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_MAX_01_SCORE`,
                "float",
                template
            );
            chest_compression_score2 = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_MAX_02_SCORE`,
                "float",
                template
            );
            chest_compression_score3 = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_MAX_03_SCORE`,
                "float",
                template
            );
            chest_compression_score1_banded = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_MAX_01_SCORE_ENCAP_BANDED`,
                "float",
                template
            );
            chest_compression_score2_banded = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_MAX_02_SCORE_ENCAP_BANDED`,
                "float",
                template
            );
            chest_compression_score3_banded = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_MAX_03_SCORE_ENCAP_BANDED`,
                "float",
                template
            );
            chest_compression_value1 = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_MAX_01_VALUE`,
                "float",
                template
            );
            chest_compression_value2 = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_MAX_02_VALUE`,
                "float",
                template
            );
            chest_compression_value3 = get_variable_value_and_ENCAP_band_score(
                status,
                `${m}_${occ}_CHEST_COMPRESSION_MAX_03_VALUE`,
                "float",
                template
            );
            chest_compression_value = Math.max(
                chest_compression_value1,
                chest_compression_value2,
                chest_compression_value3
            );
            chest_compression_value = replaceNaNWithMissing(chest_compression_value);

            let chest_and_abdomen_final = Math.min(
                chest_compression_score1_banded,
                chest_compression_score2_banded,
                chest_compression_score3_banded
            );
            chest_and_abdomen_final = replaceNaNWithMissing(chest_and_abdomen_final);

            // Then clamp *only if* they're numbers
            let chest_and_abdomen_final_score =
                // @ts-ignore
                chest_and_abdomen_final === "Missing"
                    ? "Missing"
                    : Math.max(Math.min(chest_and_abdomen_final, 100.0), 0.0);

            new Variable(
                template,
                `${m}_${occ}_CHEST_FINAL_VALUE`,
                "Final chest score",
                chest_compression_value.toString(),
                "General",
                false,
                true
            );
            new Variable(
                template,
                `${m}_${occ}_CHEST_FINAL_SCORE`,
                "Final chest score",
                chest_and_abdomen_final_score.toString(),
                "General",
                false,
                true
            );
        }
    }
}

function euroNCAPBandScore(s) {
    if (s <= 0) return "0%";
    if (s <= 0.333) return "20%";
    if (s <= 0.6667) return "40%";
    if (s < 100) return "80%";

    return "100%";
}
